/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.files;

import java.util.Comparator;
import mchorse.mclib.utils.files.EntrySorter;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;

public abstract class FileTree {
    public static Comparator<AbstractEntry> SORTER = new EntrySorter();
    public FolderEntry root = new FolderEntry("root", null, null);

    public static void addBackEntry(FolderEntry entry) {
        if (entry.parent == null) {
            return;
        }
        FolderEntry top = new FolderEntry("../", entry.parent != null ? entry.parent.file : null, entry);
        top.setTop(entry.parent);
        entry.getRawEntries().add(0, top);
    }

    public FolderEntry getEntryForName(String name) {
        for (AbstractEntry entry : this.root.getEntries()) {
            if (!(entry instanceof FolderEntry) || !entry.title.equalsIgnoreCase(name)) continue;
            return (FolderEntry)entry;
        }
        return this.root;
    }

    public FolderEntry getByPath(String path) {
        return this.getByPath(path, this.root);
    }

    public FolderEntry getByPath(String path, FolderEntry orDefault) {
        String[] segments;
        FolderEntry entry = this.root;
        for (String segment : segments = path.trim().split("/")) {
            for (AbstractEntry folder : entry.getEntries()) {
                if (!folder.isFolder() || !folder.title.equalsIgnoreCase(segment)) continue;
                entry = (FolderEntry)folder;
            }
        }
        return this.root == entry ? orDefault : entry;
    }
}

