/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.keyframes;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import io.netty.buffer.ByteBuf;
import mchorse.mclib.network.IByteBufSerializable;
import mchorse.mclib.network.INBTSerializable;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.nbt.NBTTagCompound;

public class Keyframe
implements IByteBufSerializable,
INBTSerializable {
    public Keyframe prev;
    public Keyframe next;
    @Expose
    public long tick;
    @Expose
    public double value;
    @Expose
    public KeyframeInterpolation interp = KeyframeInterpolation.LINEAR;
    @Expose
    public KeyframeEasing easing = KeyframeEasing.IN;
    @Expose
    public float rx = 5.0f;
    @Expose
    public float ry;
    @Expose
    public float lx = 5.0f;
    @Expose
    public float ly;

    public Keyframe(long tick, double value) {
        this();
        this.tick = tick;
        this.value = value;
    }

    public Keyframe() {
        this.prev = this;
        this.next = this;
    }

    public void setTick(long tick) {
        this.tick = tick;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setInterpolation(KeyframeInterpolation interp) {
        this.interp = interp;
    }

    public void setInterpolation(KeyframeInterpolation interp, KeyframeEasing easing) {
        this.interp = interp;
        this.setEasing(easing);
    }

    public void setEasing(KeyframeEasing easing) {
        this.easing = easing;
    }

    public double interpolate(Keyframe frame, float x) {
        return this.interp.interpolate(this, frame, x);
    }

    public Keyframe copy() {
        Keyframe frame = new Keyframe(this.tick, this.value);
        frame.copy(this);
        return frame;
    }

    public void copy(Keyframe keyframe) {
        this.tick = keyframe.tick;
        this.value = keyframe.value;
        this.interp = keyframe.interp;
        this.easing = keyframe.easing;
        this.lx = keyframe.lx;
        this.ly = keyframe.ly;
        this.rx = keyframe.rx;
        this.ry = keyframe.ry;
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.tick = buffer.readLong();
        this.value = buffer.readDouble();
        this.interp = KeyframeInterpolation.values()[buffer.readInt()];
        this.easing = KeyframeEasing.values()[buffer.readInt()];
        this.rx = buffer.readFloat();
        this.ry = buffer.readFloat();
        this.lx = buffer.readFloat();
        this.ly = buffer.readFloat();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.tick);
        buffer.writeDouble(this.value);
        buffer.writeInt(this.interp.ordinal());
        buffer.writeInt(this.easing.ordinal());
        buffer.writeFloat(this.rx);
        buffer.writeFloat(this.ry);
        buffer.writeFloat(this.lx);
        buffer.writeFloat(this.ly);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Tick")) {
            this.tick = tag.func_74763_f("Tick");
        }
        if (tag.func_74764_b("Value")) {
            this.value = tag.func_74769_h("Value");
        }
        if (tag.func_74764_b("Interp")) {
            this.interp = KeyframeInterpolation.values()[tag.func_74762_e("Interp")];
        }
        if (tag.func_74764_b("Easing")) {
            this.easing = KeyframeEasing.values()[tag.func_74762_e("Easing")];
        }
        if (tag.func_74764_b("RX")) {
            this.rx = tag.func_74760_g("RX");
        }
        if (tag.func_74764_b("RY")) {
            this.ry = tag.func_74760_g("RY");
        }
        if (tag.func_74764_b("LX")) {
            this.lx = tag.func_74760_g("LX");
        }
        if (tag.func_74764_b("LY")) {
            this.ly = tag.func_74760_g("LY");
        }
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound tag) {
        tag.func_74772_a("Tick", this.tick);
        tag.func_74780_a("Value", this.value);
        if (this.interp != KeyframeInterpolation.LINEAR) {
            tag.func_74768_a("Interp", this.interp.ordinal());
        }
        if (this.easing != KeyframeEasing.IN) {
            tag.func_74768_a("Easing", this.easing.ordinal());
        }
        if (this.rx != 5.0f) {
            tag.func_74776_a("RX", this.rx);
        }
        if (this.ry != 0.0f) {
            tag.func_74776_a("RY", this.ry);
        }
        if (this.lx != 5.0f) {
            tag.func_74776_a("LX", this.lx);
        }
        if (this.ly != 0.0f) {
            tag.func_74776_a("LY", this.ly);
        }
        return tag;
    }

    public void fromJSON(JsonObject object) {
        this.tick = object.get("tick").getAsLong();
        this.value = object.get("value").getAsDouble();
        this.interp = KeyframeInterpolation.valueOf(object.get("interp").getAsString());
        this.easing = KeyframeEasing.valueOf(object.get("easing").getAsString());
        this.rx = object.get("rx").getAsFloat();
        this.ry = object.get("ry").getAsFloat();
        this.lx = object.get("lx").getAsFloat();
        this.ly = object.get("ly").getAsFloat();
    }

    public JsonObject toJSON() {
        JsonObject frame = new JsonObject();
        frame.addProperty("tick", (Number)this.tick);
        frame.addProperty("value", (Number)this.value);
        frame.addProperty("interp", this.interp.toString());
        frame.addProperty("easing", this.easing.toString());
        frame.addProperty("rx", (Number)Float.valueOf(this.rx));
        frame.addProperty("ry", (Number)Float.valueOf(this.ry));
        frame.addProperty("lx", (Number)Float.valueOf(this.lx));
        frame.addProperty("ly", (Number)Float.valueOf(this.ly));
        return frame;
    }
}

