/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.wav;

import java.nio.ByteBuffer;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.wav.Wave;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.openal.AL10;

public class WavePlayer {
    private int buffer = -1;
    private int source = -1;
    private float duration;

    public WavePlayer initialize(Wave wave) {
        this.buffer = AL10.alGenBuffers();
        ByteBuffer buffer = GLAllocation.func_74524_c((int)wave.data.length);
        buffer.put(wave.data);
        buffer.flip();
        AL10.alBufferData((int)this.buffer, (int)wave.getALFormat(), (ByteBuffer)buffer, (int)wave.sampleRate);
        this.duration = wave.getDuration();
        this.source = AL10.alGenSources();
        AL10.alSourcei((int)this.source, (int)4105, (int)this.buffer);
        AL10.alSourcei((int)this.source, (int)514, (int)1);
        return this;
    }

    public void delete() {
        AL10.alDeleteBuffers((int)this.buffer);
        AL10.alDeleteSources((int)this.source);
        this.buffer = -1;
        this.source = -1;
    }

    public void play() {
        AL10.alSourcePlay((int)this.source);
    }

    public void pause() {
        AL10.alSourcePause((int)this.source);
    }

    public void stop() {
        AL10.alSourceStop((int)this.source);
    }

    public int getSourceState() {
        return AL10.alGetSourcei((int)this.source, (int)4112);
    }

    public boolean isPlaying() {
        return this.getSourceState() == 4114;
    }

    public boolean isPaused() {
        return this.getSourceState() == 4115;
    }

    public boolean isStopped() {
        int state = this.getSourceState();
        return state == 4116 || state == 4113;
    }

    public float getPlaybackPosition() {
        return AL10.alGetSourcef((int)this.source, (int)4132);
    }

    public void setPlaybackPosition(float seconds) {
        seconds = MathUtils.clamp(seconds, 0.0f, this.duration);
        AL10.alSourcef((int)this.source, (int)4132, (float)seconds);
    }

    public int getBuffer() {
        return this.buffer;
    }

    public int getSource() {
        return this.source;
    }
}

